/*
 * @(#)Main.java  2006-12-05
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.am;

import org.jhotdraw.app.*;
import org.jhotdraw.util.ResourceBundleUtil;

/**
 * The Main class launches the Activity Modeling application.
 *
 * @author Werner Randelshofer, Florian Padrun
 * @version 1.0 2006-12-05.
 */
public class Main {
    public static void main(String[] args) {
        Application app;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac")) {
            app = new OSXApplication();
        } else if (os.startsWith("win")) {
            //  app = new DefaultMDIApplication();
            app = new SDIApplication();
        } else {
            app = new SDIApplication();
        }
        
        ResourceBundleUtil.setVerbose(true);
        DefaultApplicationModel model = new AMApplicationModel();
        model.setName("UML Activity Modeler");
        model.setVersion("1.0");
        model.setCopyright("Copyright 2006 (c) Lucerne University of Applied Sciences and Arts" +
                "\nFlorian Padrun." +
                "\nSupported by tutor Professor Jordan Sucur." +
                "\nBased on software components by Werner Randelshofer.");
        model.setViewClassName("ch.hslu.cm.am.AMView");
        app.setModel(model);
        app.launch(args);
    }
}
